﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Microsoft.Reporting.WebForms;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.Business.Utilities;
using VeteransAffairs.Registries.BusinessManager.Utilities;

public partial class ReportInitialScreeningNationalSummary : System.Web.UI.Page
{

    #region Variable Declarations

    private UserAccountManager _currentUser;
    //TBIExceptionHandler _tbiexception = new TBIExceptionHandler();

    #endregion

    #region Protected Methods

    protected void Page_Load(object sender, EventArgs e)
    {
        if(AccessAllowed())
        {
            if (!Page.IsPostBack)
            {
                Session["ReportYear"] = "09";
                Session["ReportMonth"] = "August";
            }

            ReportViewer1.Visible = true;
            SetReportParameters();
        }
        else
        {
            //_tbiexception.HandleTBIException(_ex, _reportName);
            Response.Redirect("ErrorPage.aspx?id=100");
        }
    }

    #endregion

    #region Private Methods

    private void SetReportParameters()
    {
        string _reportName = "ReportScreenNationalSummary";
        
        try
        {
            ReportViewer1.Reset();
            ReportViewer1.ServerReport.ReportPath = _reportName;

            ReportViewer1.ServerReport.ReportServerUrl = new Uri(Helpers.GetConfigEntry("ReportingServer"));
            if (ReportViewer1.ServerReport.ReportPath.IndexOf(Helpers.GetConfigEntry("BaseReportPath"), 0) == -1)
            {
                ReportViewer1.ServerReport.ReportPath = Helpers.GetConfigEntry("BaseReportPath") + ReportViewer1.ServerReport.ReportPath;
            }

            ReportParameter paramMonth = new ReportParameter("Month", (string)Session["ReportMonth"]);
            ReportParameter paramYear = new ReportParameter("Year", (string)Session["ReportYear"]);
            ReportParameter paramUsername = new ReportParameter("Username", _currentUser.FullName);

            ReportViewer1.ServerReport.SetParameters(new ReportParameter[] { paramMonth, paramYear, paramUsername });
            ReportViewer1.ProcessingMode = ProcessingMode.Remote;
            ReportViewer1.ServerReport.Refresh();
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100009", "Get() ReportData");
        }

    }

    private bool AccessAllowed()
    {
        _currentUser = (UserAccountManager)HttpContext.Current.User;
        return _currentUser.IsInRole(16);
    }

    #endregion

}
